/*
 *  PXIAbstractFramework.mm
 *  Mixer
 *
 *  Created by decaf on 2/14/05.
 *  Copyright 2005 __MyCompanyName__. All rights reserved.
 *
 */

#import <Cocoa/Cocoa.h>

#import "PXIAbstractFramework.h"
#import "PXIMasterController.h"
#import "TVAskDialogController.h"
#import "TVAnswerDialogController.h"

PXIMasterController * gPXIWorld;
PXIAbstractFramework myAbstractFramework;

PXIAbstractFramework::PXIAbstractFramework( void )
{
	gPXIWorld = [[PXIMasterController alloc] init];
}

void PXIAbstractFramework::createNewWindow( const string & s )
{
	[gPXIWorld createNewWindow:[NSString stringWithCString:s.c_str()]];
}

string PXIAbstractFramework::ask ( const string & prompt, const string & defaultText )
{
	TVAskDialogController * myDialogController = [[TVAskDialogController alloc] init];
	return [[myDialogController show:[NSString stringWithCString:prompt.c_str()] withDefault:[NSString stringWithCString:defaultText.c_str()]] cString];
}

string PXIAbstractFramework::answer ( const string & prompt, const string & btn1, const string & btn2, const string & btn3 )
{
	TVAnswerDialogController * myDialogController = [[TVAnswerDialogController alloc] init];
	return [[myDialogController show:[NSString stringWithCString:prompt.c_str()] rightButton:[NSString stringWithCString:btn1.c_str()] middleButton:[NSString stringWithCString:btn2.c_str()] leftButton:[NSString stringWithCString:btn3.c_str()]] cString];
}

int PXIAbstractFramework::getCurrentTool( void )
{
	return [gPXIWorld currentTool];
}

void PXIAbstractFramework::setCurrentTool ( int newTool )
{
	[gPXIWorld setCurrentTool:newTool];
}

/*********************** Global Variables ***************************************
	These are our methods for handling global variables. Global variables are
	modeled on the local variable method of using a map (for compile time), and
	a vector (for runtime.) Variable names must be converted to numeric values
	by the compiler, where they are then accessed via interrupts.
********************************************************************************/

void PXIAbstractFramework::setGlobalVariable( int key, const variant & value )
{
	PXIGlobalVariableTable[ key ] = value;
}

variant PXIAbstractFramework::getGlobalVariable( int key )
{
	return PXIGlobalVariableTable[ key ];
}

bool PXIAbstractFramework::hasGlobalVariable( const string & key )
{
	return ( PXIGlobalVariableIndices.find( key ) != PXIGlobalVariableIndices.end() );
}

int PXIAbstractFramework::getGlobalVariableIndex( const string & key )
{
	if( hasGlobalVariable( key ) )
	{
		return ( ( *PXIGlobalVariableIndices.find( key ) ).second );
	}
	else
	{
		PXIGlobalVariableIndices.insert( pair< string, int > ( key, PXIGlobalVariableTable.size() ) );
		PXIGlobalVariableTable.push_back( variant( "" ) );
		return PXIGlobalVariableTable.size() - 1;
	}
}

long long PXIAbstractFramework::registerNewObject ( const variant & newVariant )
{
	int newObjectID = objectCounter++;
	vector < variant > newVector;
	map < string, int > newMap;
	PXIDataMemberIndices.push_back( newMap );
	PXIDataMemberTables.push_back( newVector );
	return newObjectID;
}

bool PXIAbstractFramework::objectHasKey ( long long objectSource, string memberName )
{
	if ( PXIDataMemberIndices[ objectSource ].find( memberName ) != PXIDataMemberIndices[ objectSource ].end() )
	{
		return true;
	}
	return false;
}

bool PXIAbstractFramework::objectHasIndex ( long long objectSource, long long memberKey )
{
	if ( PXIDataMemberTables[ objectSource ].size() >= memberKey )
	{
		return true;
	}
	return false;
}

void PXIAbstractFramework::duplicateObject ( long long objectDestination, long long objectSource )
{
	// This function copies the data members from the first object to the second.
	if ( ! PXIDataMemberTables[ objectSource ].empty() )
	{
		PXIDataMemberTables[ objectDestination ] = PXIDataMemberTables[ objectSource ];
	}
}